/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.FmtUI;
import com.quantumdata.fmteditor.editor.BackPorchHandler;
import com.quantumdata.fmteditor.editor.FmtABPTriad;
import com.quantumdata.fmteditor.editor.FmtFieldTriad;
import com.quantumdata.fmteditor.editor.FmtFieldTriadSpec;
import com.quantumdata.fmteditor.editor.FmtRateTriad;
import com.quantumdata.fmteditor.editor.UnitPair;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.fmteditor.fmtwidgets.FmtButtonUI;
import com.quantumdata.fmteditor.fmtwidgets.FmtCheckBox;
import com.quantumdata.fmteditor.fmtwidgets.FmtNumericField;
import com.quantumdata.fmteditor.fmtwidgets.FmtRadioGroup;
import com.quantumdata.fmteditor.fmtwidgets.NamedValue;
import com.quantumdata.std.QDUtil;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class FmtTimingPanel
extends QDPanel {
    private Format m_fmt;
    private CmdValue m_units;
    private Vector<UnitPair> m_pairs = new Vector();
    private FmtFieldTriad m_hmachTriad;
    private FmtFieldTriad m_htimeTriad;
    private FmtFieldTriad m_vmachTriad;
    private FmtFieldTriad m_vtimeTriad;
    private FmtRateTriad m_rateTriad;
    private Vector<JToggleButton> m_selectors = new Vector();
    private Vector<FmtNumericField> m_primaryFields = new Vector();
    private Vector<FmtNumericField> m_timeFields = new Vector();
    private Icon[] m_icons = null;
    private BackPorchHandler m_backPorch;
    private JTextField m_bpLabel;

    public FmtTimingPanel(Format format) {
        this.m_fmt = format;
        this.setLayout(new BorderLayout());
        NamedValue[] namedValueArray = new NamedValue[]{new NamedValue("Machine", 0), new NamedValue("Time", 1)};
        this.m_units = new CmdValue(CmdValueType.INT, "UNITS", 0.0, namedValueArray, "");
        FmtNumericField fmtNumericField = new FmtNumericField(this.m_fmt.getValue("HRAT"), 1000.0);
        FmtNumericField fmtNumericField2 = new FmtNumericField(new CmdValue(CmdValueType.DOUBLE, "VRAT", 0.0, ""));
        FmtNumericField fmtNumericField3 = new FmtNumericField(new CmdValue(CmdValueType.DOUBLE, "PRAT", 0.0, ""), 1000000.0);
        this.m_primaryFields.add(fmtNumericField);
        this.m_primaryFields.add(fmtNumericField2);
        this.m_primaryFields.add(fmtNumericField3);
        this.m_fmt.addValue(fmtNumericField2.getValue());
        this.m_fmt.addValue(fmtNumericField3.getValue());
        double d = this.m_fmt.getValue("HRAT").getDouble();
        double d2 = this.m_fmt.getValue("SCAN").getDouble();
        double d3 = this.m_fmt.getValue("VTOT").getDouble();
        fmtNumericField2.getValue().setDouble(d / d3 * d2);
        d3 = this.m_fmt.getValue("HTOT").getDouble();
        fmtNumericField3.getValue().setDouble(d * d3);
        this.m_icons = new Icon[6];
        this.m_icons[0] = QDUtil.loadIcon((String)"triadUnsel.png");
        this.m_icons[1] = QDUtil.loadIcon((String)"triadSel.png");
        this.m_icons[2] = QDUtil.loadIcon((String)"triadRollUnsel.png");
        this.m_icons[3] = QDUtil.loadIcon((String)"triadDisabledUnsel.png");
        this.m_icons[4] = QDUtil.loadIcon((String)"triadRollSel.png");
        this.m_icons[5] = QDUtil.loadIcon((String)"triadDisabledSel.png");
        this.add((Component)this.createMainPanel(), "Center");
        this.m_units.setBool(false);
        this.m_units.addListener(new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtTimingPanel.this.entryUnitsChanged();
            }
        });
        FmtFieldTriadSpec fmtFieldTriadSpec = new FmtFieldTriadSpec("HMACH", 3);
        fmtFieldTriadSpec.fields[0] = this.getPrimary("HRES");
        fmtFieldTriadSpec.fields[1] = this.getPrimary("HBNK");
        fmtFieldTriadSpec.fields[2] = this.getPrimary("HTOT");
        fmtFieldTriadSpec.selectors[0] = this.getSelector("HRES");
        fmtFieldTriadSpec.selectors[1] = this.getSelector("HBNK");
        fmtFieldTriadSpec.selectors[2] = this.getSelector("HTOT");
        this.m_hmachTriad = new FmtABPTriad(fmtFieldTriadSpec, 1, null);
        fmtFieldTriadSpec.name = "HTIME";
        fmtFieldTriadSpec.fields[0] = this.getTime("HRES");
        fmtFieldTriadSpec.fields[1] = this.getTime("HBNK");
        fmtFieldTriadSpec.fields[2] = this.getTime("HTOT");
        this.m_htimeTriad = new FmtABPTriad(fmtFieldTriadSpec, 1, fmtNumericField3.getValue());
        fmtFieldTriadSpec.name = "VMACH";
        fmtFieldTriadSpec.fields[0] = this.getPrimary("VRES");
        fmtFieldTriadSpec.fields[1] = this.getPrimary("VBNK");
        fmtFieldTriadSpec.fields[2] = this.getPrimary("VTOT");
        fmtFieldTriadSpec.selectors[0] = this.getSelector("VRES");
        fmtFieldTriadSpec.selectors[1] = this.getSelector("VBNK");
        fmtFieldTriadSpec.selectors[2] = this.getSelector("VTOT");
        this.m_vmachTriad = new FmtABPTriad(fmtFieldTriadSpec, 1, null);
        fmtFieldTriadSpec.name = "VTIME";
        fmtFieldTriadSpec.fields[0] = this.getTime("VRES");
        fmtFieldTriadSpec.fields[1] = this.getTime("VBNK");
        fmtFieldTriadSpec.fields[2] = this.getTime("VTOT");
        this.m_vtimeTriad = new FmtABPTriad(fmtFieldTriadSpec, 1, this.m_fmt.getValue("HRAT"));
        fmtFieldTriadSpec = new FmtFieldTriadSpec("RATES", 6);
        fmtFieldTriadSpec.mode = 1;
        fmtFieldTriadSpec.fields[0] = this.getPrimary("PRAT");
        fmtFieldTriadSpec.fields[1] = this.getPrimary("HRAT");
        fmtFieldTriadSpec.fields[2] = this.getPrimary("VRAT");
        fmtFieldTriadSpec.fields[3] = this.getTime("PRAT");
        fmtFieldTriadSpec.fields[4] = this.getPrimary("HRAT0");
        fmtFieldTriadSpec.fields[5] = this.getPrimary("TUNE");
        fmtFieldTriadSpec.selectors[0] = this.getSelector("PRAT");
        fmtFieldTriadSpec.selectors[1] = this.getSelector("HRAT");
        fmtFieldTriadSpec.selectors[2] = this.getSelector("VRAT");
        this.m_rateTriad = new FmtRateTriad(fmtFieldTriadSpec, this.m_fmt, 0);
        this.entryUnitsChanged();
        this.m_backPorch = new BackPorchHandler(this.m_fmt, this.m_bpLabel, this.getPair("HSPD"), this.getPair("VSPD"), fmtNumericField3.getValue());
    }

    private JToggleButton getSelector(String string) {
        for (JToggleButton jToggleButton : this.m_selectors) {
            if (!jToggleButton.getName().equalsIgnoreCase(string)) continue;
            return jToggleButton;
        }
        return null;
    }

    private FmtNumericField getPrimary(String string) {
        for (FmtNumericField fmtNumericField : this.m_primaryFields) {
            if (!fmtNumericField.getValue().getName().equalsIgnoreCase(string)) continue;
            return fmtNumericField;
        }
        return null;
    }

    private FmtNumericField getTime(String string) {
        for (FmtNumericField fmtNumericField : this.m_timeFields) {
            if (!fmtNumericField.getValue().getName().equalsIgnoreCase(string)) continue;
            return fmtNumericField;
        }
        return null;
    }

    private UnitPair getPair(String string) {
        for (UnitPair unitPair : this.m_pairs) {
            if (!unitPair.name().equalsIgnoreCase(string)) continue;
            return unitPair;
        }
        return null;
    }

    private QDPanel createMainPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        QDPanel qDPanel2 = this.createColorLegendPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        qDPanel2 = this.createPixelRatePanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        qDPanel2 = this.createLabelPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        qDPanel2 = this.createHorzPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        qDPanel2 = this.createVertPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        qDPanel2 = this.createRightPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        qDPanel2 = this.createBottomPanel();
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        return qDPanel;
    }

    private QDPanel createRightPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        FmtRadioGroup fmtRadioGroup = new FmtRadioGroup("Entry Units", this.m_units, true, false);
        gridBagLayout.setConstraints((Component)((Object)fmtRadioGroup), gridBagConstraints);
        qDPanel.add((Component)((Object)fmtRadioGroup));
        ++gridBagConstraints.gridy;
        fmtRadioGroup = new FmtRadioGroup("Scan Type", this.m_fmt.getValue("SCAN"), true, true);
        gridBagLayout.setConstraints((Component)((Object)fmtRadioGroup), gridBagConstraints);
        qDPanel.add((Component)((Object)fmtRadioGroup));
        ++gridBagConstraints.gridy;
        fmtRadioGroup = this.createOptPanel();
        gridBagLayout.setConstraints((Component)((Object)fmtRadioGroup), gridBagConstraints);
        qDPanel.add((Component)((Object)fmtRadioGroup));
        ++gridBagConstraints.gridy;
        String[] stringArray = new String[]{"Clock Pulse", "PreEmphasis", "DC Balance", "Flat Front Porch", "TriLevel", "Repeat Field"};
        String[] stringArray2 = new String[]{"PCPG", "PREG", "BALG", "EQUF", "TSPG", "RFLD"};
        fmtRadioGroup = this.createCheckPanel(stringArray, stringArray2);
        gridBagLayout.setConstraints((Component)((Object)fmtRadioGroup), gridBagConstraints);
        qDPanel.add((Component)((Object)fmtRadioGroup));
        fmtRadioGroup = new QDPanel((LayoutManager)new BorderLayout());
        fmtRadioGroup.add((Component)qDPanel, "Center");
        return fmtRadioGroup;
    }

    private QDPanel createBottomPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        QDPanel qDPanel2 = new QDPanel((LayoutManager)gridBagLayout2);
        FmtUI.addTrio(0, 0, qDPanel2, this.createRowLabel("Serration width Adjustment"), new FmtNumericField(this.m_fmt.getValue("HVSA")), (JComponent)FmtUI.createUnitLabel("Pixels"));
        FmtUI.addTrio(0, 1, qDPanel2, this.createRowLabel("H to V Pulse Delay"), new FmtNumericField(this.m_fmt.getValue("HVPD")), (JComponent)FmtUI.createUnitLabel("Pixels"));
        CmdValue cmdValue = new CmdValue(CmdValueType.INT, "HBPD", 0.0, "HBPD: Horizontal Broad Pulse Delay");
        this.m_fmt.addValue(cmdValue);
        FmtNumericField fmtNumericField = new FmtNumericField(cmdValue);
        fmtNumericField.setToolTipText("The HBPD value (read only)");
        fmtNumericField.setEnabled(false);
        FmtUI.addTrio(0, 2, qDPanel2, this.createRowLabel("Horizontal Broad Pulse Delay"), fmtNumericField, (JComponent)FmtUI.createUnitLabel("Pixels"));
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        gridBagLayout2 = new GridBagLayout();
        qDPanel2 = new QDPanel((LayoutManager)gridBagLayout2);
        FmtUI.addTrio(0, 0, qDPanel2, this.createRowLabel("Eq. Before"), new FmtNumericField(this.m_fmt.getValue("EQUB")), (JComponent)FmtUI.createUnitLabel("Lines"));
        FmtUI.addTrio(0, 1, qDPanel2, this.createRowLabel("Eq. After"), new FmtNumericField(this.m_fmt.getValue("EQUA")), (JComponent)FmtUI.createUnitLabel("Lines"));
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        qDPanel2 = new QDPanel((LayoutManager)new BorderLayout());
        qDPanel2.add((Component)qDPanel, (Object)"Center");
        qDPanel2.setBorder(FmtUI.createLoweredBorder(5));
        CmdValueListener cmdValueListener = new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtTimingPanel.this.updateHbpd();
            }
        };
        this.m_fmt.getValue("AVST").addListener(cmdValueListener);
        this.m_fmt.getValue("HSPD").addListener(cmdValueListener);
        this.m_fmt.getValue("HSPW").addListener(cmdValueListener);
        return qDPanel2;
    }

    private QDPanel createColorLegendPanel() {
        QDPanel qDPanel = new QDPanel();
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        JTextField jTextField = this.createRowLabel("Calculated");
        QDLabel qDLabel = this.createSmallLabel("    ");
        qDLabel.setBackground(new Color(128, 0, 0));
        qDLabel.setOpaque(true);
        qDPanel.add((Component)qDLabel);
        qDPanel.add((Component)jTextField);
        return qDPanel;
    }

    private QDPanel createPixelRatePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        QDLabel qDLabel = this.createSmallLabel("Pixel Rate");
        gridBagLayout.setConstraints((Component)qDLabel, gridBagConstraints);
        qDPanel.add((Component)qDLabel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        JToggleButton jToggleButton = this.createCalcButton("PRAT");
        jToggleButton.setToolTipText("Set PRAT as user entered");
        gridBagLayout.setConstraints(jToggleButton, gridBagConstraints);
        qDPanel.add((Component)jToggleButton);
        ++gridBagConstraints.gridx;
        FmtNumericField fmtNumericField = this.getPrimary("PRAT");
        fmtNumericField.setToolTipText("Enter PRAT in MHz");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(fmtNumericField, gridBagConstraints);
        qDPanel.add((Component)fmtNumericField);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        qDLabel = FmtUI.createUnitLabel("MHz");
        gridBagLayout.setConstraints((Component)qDLabel, gridBagConstraints);
        qDPanel.add((Component)qDLabel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 20;
        FmtNumericField fmtNumericField2 = new FmtNumericField(new CmdValue(CmdValueType.DOUBLE, "PRAT", 0.0, ""), 1.0E-9);
        fmtNumericField2.setToolTipText("Enter PRAT in ns");
        this.m_timeFields.add(fmtNumericField2);
        gridBagLayout.setConstraints(fmtNumericField2, gridBagConstraints);
        qDPanel.add((Component)fmtNumericField2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 3;
        qDLabel = FmtUI.createUnitLabel("ns");
        gridBagLayout.setConstraints((Component)qDLabel, gridBagConstraints);
        qDPanel.add((Component)qDLabel);
        UnitPair unitPair = new UnitPair("PRAT", fmtNumericField, fmtNumericField2, this.m_units, null);
        this.m_pairs.add(unitPair);
        return qDPanel;
    }

    private QDPanel createLabelPanel() {
        String[] stringArray;
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        QDLabel qDLabel = new QDLabel();
        for (String string : stringArray = new String[]{"  ", "Rate", "  ", "Active", "Blank", "Total", "Pulse Delay", "Pulse Width"}) {
            JTextField jTextField = this.createRowLabel(string);
            jTextField.setFont(qDLabel.getFont());
            gridBagConstraints.insets.top = gridBagConstraints.gridy == 2 ? 3 : 3;
            gridBagLayout.setConstraints(jTextField, gridBagConstraints);
            qDPanel.add((Component)jTextField);
            if (string.equalsIgnoreCase("pulse delay")) {
                this.m_bpLabel = jTextField;
            }
            ++gridBagConstraints.gridy;
        }
        return qDPanel;
    }

    private QDPanel createVertPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        qDPanel.setBorder(FmtUI.createLoweredBorder(10, 5));
        this.addRateHeader(false, qDPanel);
        CmdValue cmdValue = this.getPrimary("HRAT").getValue();
        int n = 3;
        this.addRow(n++, "VRES", "Lines", true, "ms", qDPanel, cmdValue, 0.001);
        this.addRow(n++, "VBNK", "Lines", true, "ms", qDPanel, cmdValue, 0.001);
        this.addRow(n++, "VTOT", "Lines", true, "ms", qDPanel, cmdValue, 0.001);
        this.addRow(n++, "VSPD", "Lines", false, "ms", qDPanel, cmdValue, 0.001);
        this.addRow(n++, "VSPW", "Lines", false, "ms", qDPanel, cmdValue, 0.001);
        this.getPrimary("VSPD").setRange(0, 65535);
        this.getPrimary("VSPW").setRange(1, 65535);
        return qDPanel;
    }

    private QDPanel createHorzPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        qDPanel.setBorder(FmtUI.createLoweredBorder(10, 5));
        this.addRateHeader(true, qDPanel);
        CmdValue cmdValue = this.getPrimary("PRAT").getValue();
        int n = 3;
        this.addRow(n++, "HRES", "Pixels", true, "us", qDPanel, cmdValue, 1.0E-6);
        this.addRow(n++, "HBNK", "Pixels", true, "us", qDPanel, cmdValue, 1.0E-6);
        this.addRow(n++, "HTOT", "Pixels", true, "us", qDPanel, cmdValue, 1.0E-6);
        this.addRow(n++, "HSPD", "Pixels", false, "us", qDPanel, cmdValue, 1.0E-6);
        this.addRow(n++, "HSPW", "Pixels", false, "us", qDPanel, cmdValue, 1.0E-6);
        this.getPrimary("HSPD").setRange(0, 65535);
        this.getPrimary("HSPW").setRange(1, 65535);
        return qDPanel;
    }

    private JToggleButton createCalcButton(String string) {
        JToggleButton jToggleButton = new JToggleButton(this.m_icons[0]);
        jToggleButton.setSelectedIcon(this.m_icons[1]);
        jToggleButton.setDisabledIcon(this.m_icons[3]);
        jToggleButton.setDisabledSelectedIcon(this.m_icons[5]);
        jToggleButton.setRolloverEnabled(true);
        jToggleButton.setRolloverIcon(this.m_icons[2]);
        jToggleButton.setRolloverSelectedIcon(this.m_icons[4]);
        jToggleButton.setFocusPainted(true);
        jToggleButton.setBorderPainted(false);
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setSize(new Dimension(this.m_icons[0].getIconWidth(), this.m_icons[0].getIconHeight()));
        jToggleButton.setEnabled(true);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.setName(string);
        jToggleButton.setUI(FmtButtonUI.create());
        jToggleButton.setBorderPainted(false);
        this.m_selectors.add(jToggleButton);
        return jToggleButton;
    }

    private QDLabel createSmallLabel(String string) {
        QDLabel qDLabel = new QDLabel(string);
        qDLabel.setForeground(QDStdUI.getActionForeground());
        return qDLabel;
    }

    private JTextField createRowLabel(String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setEditable(false);
        jTextField.setForeground(QDStdUI.getActionForeground());
        jTextField.setOpaque(false);
        jTextField.setBorder(BorderFactory.createLineBorder(QDStdUI.getBackground(), 3));
        return jTextField;
    }

    private void addRateHeader(boolean bl, QDPanel qDPanel) {
        String string;
        String string2;
        FmtNumericField fmtNumericField;
        String string3;
        if (bl) {
            string3 = "Horizontal";
            fmtNumericField = this.getPrimary("HRAT");
            string2 = "KHz";
            string = "Enter HRAT in KHz (TUNE = HRAT0 / HRAT)";
        } else {
            string3 = "Vertical";
            fmtNumericField = this.getPrimary("VRAT");
            string2 = "Hz";
            string = "Enter VRAT in Hz";
        }
        GridBagLayout gridBagLayout = (GridBagLayout)qDPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        QDLabel qDLabel = this.createSmallLabel(string3);
        gridBagLayout.setConstraints((Component)qDLabel, gridBagConstraints);
        qDPanel.add((Component)qDLabel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        QDPanel qDPanel2 = new QDPanel((LayoutManager)gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        JToggleButton jToggleButton = this.createCalcButton(fmtNumericField.getValue().getName());
        jToggleButton.setToolTipText("Set " + fmtNumericField.getValue().getName() + " as user entered");
        gridBagLayout2.setConstraints(jToggleButton, gridBagConstraints2);
        qDPanel2.add((Component)jToggleButton);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagLayout2.setConstraints(fmtNumericField, gridBagConstraints2);
        fmtNumericField.setToolTipText(string);
        qDPanel2.add((Component)fmtNumericField);
        qDLabel = FmtUI.createUnitLabel(string2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagLayout2.setConstraints((Component)qDLabel, gridBagConstraints2);
        qDPanel2.add((Component)qDLabel);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
        qDPanel.add((Component)qDPanel2);
        if (bl) {
            Font font = new Font("Serif", 0, 10);
            gridBagLayout2 = new GridBagLayout();
            qDPanel2 = new QDPanel((LayoutManager)gridBagLayout2);
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            qDLabel = this.createSmallLabel("Tune");
            qDLabel.setFont(font);
            gridBagLayout2.setConstraints((Component)qDLabel, gridBagConstraints2);
            qDPanel2.add((Component)qDLabel);
            ++gridBagConstraints2.gridx;
            fmtNumericField = new FmtNumericField(this.m_fmt.getValue("TUNE"));
            fmtNumericField.setToolTipText("Enter the TUNE factor where HRAT = HRAT0 / TUNE");
            this.m_primaryFields.add(fmtNumericField);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagLayout2.setConstraints(fmtNumericField, gridBagConstraints2);
            qDPanel2.add((Component)fmtNumericField);
            ++gridBagConstraints2.gridx;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.insets.left = 10;
            qDLabel = this.createSmallLabel("Base");
            qDLabel.setFont(font);
            gridBagLayout2.setConstraints((Component)qDLabel, gridBagConstraints2);
            qDPanel2.add((Component)qDLabel);
            ++gridBagConstraints2.gridx;
            fmtNumericField = new FmtNumericField(this.m_fmt.getValue("HRAT0"), 1000.0);
            fmtNumericField.setToolTipText("Enter HRAT0 where HRAT = HRAT0 / TUNE");
            this.m_primaryFields.add(fmtNumericField);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets.left = 3;
            gridBagLayout2.setConstraints(fmtNumericField, gridBagConstraints2);
            qDPanel2.add((Component)fmtNumericField);
            qDLabel = FmtUI.createUnitLabel("KHz");
            ++gridBagConstraints2.gridx;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 0;
            gridBagLayout2.setConstraints((Component)qDLabel, gridBagConstraints2);
            qDPanel2.add((Component)qDLabel);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets.top = 1;
            gridBagLayout.setConstraints((Component)qDPanel2, gridBagConstraints);
            qDPanel.add((Component)qDPanel2);
        } else {
            JTextField jTextField = this.createRowLabel(" ");
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets.top = 1;
            gridBagLayout.setConstraints(jTextField, gridBagConstraints);
            qDPanel.add((Component)jTextField);
        }
    }

    private void addRow(int n, String string, String string2, boolean bl, String string3, QDPanel qDPanel, CmdValue cmdValue, double d) {
        JToggleButton jToggleButton;
        GridBagLayout gridBagLayout = (GridBagLayout)qDPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        CmdValue cmdValue2 = this.m_fmt.getValue(string);
        if (cmdValue2 == null) {
            cmdValue2 = new CmdValue(CmdValueType.INT, string, 0.0, "");
        }
        FmtNumericField fmtNumericField = new FmtNumericField(cmdValue2);
        fmtNumericField.setToolTipText("Enter " + cmdValue2.getName() + " in " + string2);
        this.m_primaryFields.add(fmtNumericField);
        gridBagLayout.setConstraints(fmtNumericField, gridBagConstraints);
        qDPanel.add((Component)fmtNumericField);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        QDLabel qDLabel = FmtUI.createUnitLabel(string2);
        gridBagLayout.setConstraints((Component)qDLabel, gridBagConstraints);
        qDPanel.add((Component)qDLabel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 20;
        if (bl) {
            jToggleButton = this.createCalcButton(string);
            jToggleButton.setToolTipText("Set " + cmdValue2.getName() + " as auto-calculated");
        } else {
            jToggleButton = this.createSmallLabel(" ");
        }
        gridBagLayout.setConstraints(jToggleButton, gridBagConstraints);
        qDPanel.add((Component)jToggleButton);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 3;
        FmtNumericField fmtNumericField2 = new FmtNumericField(new CmdValue(CmdValueType.DOUBLE, string, 0.0, ""), d);
        fmtNumericField2.setToolTipText("Enter " + cmdValue2.getName() + " in " + string3);
        this.m_timeFields.add(fmtNumericField2);
        gridBagLayout.setConstraints(fmtNumericField2, gridBagConstraints);
        qDPanel.add((Component)fmtNumericField2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        qDLabel = FmtUI.createUnitLabel(string3);
        gridBagLayout.setConstraints((Component)qDLabel, gridBagConstraints);
        qDPanel.add((Component)qDLabel);
        UnitPair unitPair = new UnitPair(string, fmtNumericField, fmtNumericField2, this.m_units, cmdValue);
        this.m_pairs.add(unitPair);
    }

    private QDPanel createCheckPanel(String[] stringArray, String[] stringArray2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        for (int i = 0; i < stringArray.length; ++i) {
            FmtCheckBox fmtCheckBox = new FmtCheckBox(this.m_fmt.getValue(stringArray2[i]), stringArray[i]);
            gridBagLayout.setConstraints((Component)((Object)fmtCheckBox), gridBagConstraints);
            qDPanel.add((Component)((Object)fmtCheckBox));
            ++gridBagConstraints.gridy;
        }
        return qDPanel;
    }

    private QDPanel createOptPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        QDPanel qDPanel = new QDPanel((LayoutManager)gridBagLayout);
        qDPanel.setBorder(FmtUI.createLoweredBorder(5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        QDCheckBox qDCheckBox = new QDCheckBox("Back Porch");
        gridBagLayout.setConstraints((Component)qDCheckBox, gridBagConstraints);
        qDPanel.add((Component)qDCheckBox);
        qDCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmtTimingPanel.this.useBackPorch(((QDCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        qDCheckBox.setToolTipText("Toggle Pulse Delay / Back Porch fields");
        return qDPanel;
    }

    private void useBackPorch(boolean bl) {
        this.m_backPorch.enable(bl);
    }

    private void entryUnitsChanged() {
        boolean bl = !this.m_units.getBool();
        this.m_hmachTriad.setEnabled(bl);
        this.m_vmachTriad.setEnabled(bl);
        this.m_htimeTriad.setEnabled(!bl);
        this.m_vtimeTriad.setEnabled(!bl);
        this.m_rateTriad.setEnabled(bl);
    }

    private void updateHbpd() {
        int n = 0;
        int n2 = this.m_fmt.getInt("AVST");
        switch (n2) {
            case 10: 
            case 15: {
                n = 2 * this.m_fmt.getInt("HSPW");
                break;
            }
            case 12: {
                n = this.m_fmt.getInt("HSPW") + 3 * this.m_fmt.getInt("HSPD");
            }
        }
        this.m_fmt.getValue("HBPD").setInt(n);
    }
}

